<?php

namespace App\Http\Controllers\Influencer;

use App\Models\Form;
use App\Models\Order;
use App\Models\Hiring;
use App\Lib\FormProcessor;
use App\Models\Withdrawal;
use App\Models\Transaction;
use Illuminate\Http\Request;
use App\Lib\GoogleAuthenticator;
use App\Http\Controllers\Controller;

class InfluencerController extends Controller
{

    public function home() {
        $pageTitle = "Dashboard";

        $influencer =  authInfluencer();
        $data['balance'] = $influencer->balance;
        $data['total_order'] = Order::where('influencer_id',$influencer->id)->count();
        $data['complete_order'] = Order::completed()->where('influencer_id',$influencer->id)->count();
        $data['total_hired'] = Hiring::where('influencer_id',$influencer->id)->count();

        $withdrawalsReport = Withdrawal::selectRaw("SUM(amount) as amount, MONTHNAME(created_at) as month_name, MONTH(created_at) as month_num")
        ->whereYear('created_at', date('Y'))
        ->whereStatus(1)
        ->where('user_id',$influencer->id)
        ->groupBy('month_name', 'month_num')
        ->orderBy('month_num')
        ->get();
        $withdrawalsChart['labels'] = $withdrawalsReport->pluck('month_name');
        $withdrawalsChart['values'] = $withdrawalsReport->pluck('amount');

        $orders = Order::with('user')->where('influencer_id', $influencer->id)->latest()->limit(6)->get();

        return view($this->activeTemplate .'influencer.dashboard', compact('pageTitle','data','withdrawalsChart','orders'));

    }

    public function show2faForm() {
        $general    = gs();
        $ga         = new GoogleAuthenticator();
        $influencer = authInfluencer();
        $secret     = $ga->createSecret();
        $qrCodeUrl  = $ga->getQRCodeGoogleUrl($influencer->username . '@' . $general->site_name, $secret);
        $pageTitle  = '2FA Security';
        return view($this->activeTemplate . 'influencer.twofactor', compact('pageTitle', 'secret', 'qrCodeUrl'));
    }

    public function create2fa(Request $request) {
        $influencer = authInfluencer();
        $this->validate($request, [
            'key'  => 'required',
            'code' => 'required',
        ]);
        $response = verifyG2fa($influencer, $request->code, $request->key);

        if ($response) {
            $influencer->tsc = $request->key;
            $influencer->ts  = 1;
            $influencer->save();
            $notify[] = ['success', 'Google authenticator activated successfully'];
            return back()->withNotify($notify);
        } else {
            $notify[] = ['error', 'Wrong verification code'];
            return back()->withNotify($notify);
        }

    }

    public function disable2fa(Request $request) {
        $this->validate($request, [
            'code' => 'required',
        ]);

        $influencer = authInfluencer();
        $response   = verifyG2fa($influencer, $request->code);

        if ($response) {
            $influencer->tsc = null;
            $influencer->ts  = 0;
            $influencer->save();
            $notify[] = ['success', 'Two factor authenticator deactivated successfully'];
        } else {
            $notify[] = ['error', 'Wrong verification code'];
        }

        return back()->withNotify($notify);
    }

    public function influencerData() {
        $influencer = authInfluencer();

        if ($influencer->reg_step == 1) {
            return to_route('influencer.home');
        }

        $pageTitle = 'Influencer Data';
        return view($this->activeTemplate .'influencer.influencer_data', compact('pageTitle', 'influencer'));
    }

    public function influencerDataSubmit(Request $request) {
        $influencer = authInfluencer();

        if ($influencer->reg_step == 1) {
            return to_route('influencer.home');
        }

        $request->validate([
            'firstname' => 'required',
            'lastname'  => 'required',
        ]);
        $influencer->firstname = $request->firstname;
        $influencer->lastname  = $request->lastname;
        $influencer->address   = [
            'country' => @$influencer->address->country,
            'address' => $request->address,
            'state'   => $request->state,
            'zip'     => $request->zip,
            'city'    => $request->city,
        ];
        $influencer->reg_step = 1;
        $influencer->save();

        $notify[] = ['success', 'Registration process completed successfully'];
        return to_route('influencer.home')->withNotify($notify);
    }

    public function transactions(Request $request) {
        $pageTitle    = 'Transactions';
        $remarks      = Transaction::where('influencer_id', authInfluencerId())->distinct('remark')->orderBy('remark')->get('remark');
        $transactions = Transaction::where('influencer_id', authInfluencerId());

        if ($request->search) {
            $transactions = $transactions->where('trx', $request->search);
        }

        if ($request->type) {
            $transactions = $transactions->where('trx_type', $request->type);
        }

        if ($request->remark) {
            $transactions = $transactions->where('remark', $request->remark);
        }

        $transactions = $transactions->orderBy('id', 'desc')->paginate(getPaginate());
        return view($this->activeTemplate . 'influencer.transactions', compact('pageTitle', 'transactions', 'remarks'));
    }

    public function kycForm() {

        if (authInfluencer()->kv == 2) {
            $notify[] = ['error', 'Your KYC is under review'];
            return to_route('influencer.home')->withNotify($notify);
        }

        if (authInfluencer()->kv == 1) {
            $notify[] = ['error', 'You are already KYC verified'];
            return to_route('influencer.home')->withNotify($notify);
        }

        $pageTitle = 'KYC Form';
        return view($this->activeTemplate . 'influencer.kyc.form', compact('pageTitle'));
    }

    public function kycData() {
        $influencer = authInfluencer();
        $pageTitle  = 'KYC Data';
        return view($this->activeTemplate . 'influencer.kyc.info', compact('pageTitle', 'influencer'));
    }

    public function kycSubmit(Request $request) {

        $form           = Form::where('act', 'influencer_kyc')->first();
        $formData       = $form->form_data;
        $formProcessor  = new FormProcessor();
        $validationRule = $formProcessor->valueValidation($formData);
        $request->validate($validationRule);
        $influencerData       = $formProcessor->processFormData($request, $formData);
        $influencer           = authInfluencer();
        $influencer->kyc_data = $influencerData;
        $influencer->kv       = 2;
        $influencer->save();

        $notify[] = ['success', 'KYC data submitted successfully'];
        return to_route('influencer.home')->withNotify($notify);
    }
}
