@extends('admin.layouts.app')
@section('panel')


<div class="d-flex flex-wrap justify-content-end mb-3">
    <div class="d-inline">
        <div class="input-group justify-content-end">
            <input type="text" name="search_table" class="form-control bg--white"
                placeholder="@lang('Search Category')...">
            <button class="btn btn--primary input-group-text"><i class="fa fa-search"></i></button>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-body p-0">
                <div class="table-responsive--sm table-responsive">
                    <table class="table table--light style--two custom-data-table">
                        <thead>
                            <tr>
                                <th>@lang('SL')</th>
                                <th>@lang('Image')</th>
                                <th>@lang('Name')</th>
                                <th>@lang('status')</th>
                                <th>@lang('Action')</th>
                            </tr>
                        </thead>
                        <tbody class="list">
                            @forelse($categories as $key=>$category)
                            <tr>
                                <td>{{$key+1}}</td>
                                <td>   <img class="img-thumbnail" src="{{getImage(getFilePath('category').'/'.@$category->image)}}" alt="@lang('category image')" class="rounded" style="width:60px;"></td>
                                <td>{{__($category->name)}}</td>
                                <td>
                                    @php
                                    echo $category->statusBadge($category->status);
                                    @endphp
                                </td>
                                <td>
                                    <button type="button" class="btn btn-sm btn-outline--primary editModalBtn"
                                        title="@lang('Edit')" data-data="{{ json_encode($category->only('name','icon','status', 'id')) }}">
                                        <i class="la la-edit"></i>
                                    </button>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td class="text-muted text-center" colspan="100%">{{__($emptyMessage) }}</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
            @if ($categories->hasPages())
            <div class="card-footer py-4">
                {{ paginateLinks($categories) }}
            </div>
            @endif
        </div>
    </div>
</div>

@push('breadcrumb-plugins')
<a href="javascript:void(0)" class="btn btn-sm btn--primary addCategory">@lang('Add New')</a>
@endpush

{{-- Add METHOD MODAL --}}
<div id="addCityModel" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"> @lang('Add Category')</h5>
                <button type="button" class="close btn btn--danger" data-bs-dismiss="modal" aria-label="Close">
                    <i class="las la-times"></i>
                </button>
            </div>
            <form action="{{ route('admin.category.store') }}" class="edit-route" method="POST" enctype="multipart/form-data">
                @csrf

                <div class="modal-body">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="form-group">
                                <label>@lang('Name')</label>
                                <div class="input-group">
                                    <input type="text" class="form-control" autocomplete="off" name="name" required>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div class="form-group">
                                <label>@lang('Image')</label>
                                <div class="file-upload-wrapper"
                                    data-text="@lang('Select your image!')">
                                    <input type="file" name="image" class="file-upload-field" required>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="submit" class="btn btn--primary btn-global">@lang('Submit')</button>
                </div>

            </form>
        </div>
    </div>
</div>


{{-- EDIT MODAL --}}
<div class="modal fade" id="editCategoryModal" tabindex="-1" role="dialog" aria-labelledby="editModalLabel"
    aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="editModalLabel">@lang('Update Category')</h4>
                <button type="button" class="close btn btn--danger" data-bs-dismiss="modal" aria-label="Close"><i
                        class="las la-times"></i>
                </button>
            </div>
            <form action="{{route('admin.category.update')}}" method="post" enctype="multipart/form-data">
                @csrf
                <input type="hidden" name="id">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="form-group">
                                <label>@lang('Name')</label>
                                <div class="col-sm-12">
                                    <input type="text" class="form-control" value="{{ old('name') }}" name="name"
                                        required>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-12">
                            <div class="form-group">
                                <label>@lang('Image')</label>
                                <div class="file-upload-wrapper"
                                    data-text="@lang('Select your image!')">
                                    <input type="file" name="image" class="file-upload-field">
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-12">
                            <div class="form-group mt-2">
                                <label for="status">@lang('Category Status')</label>
                                <select id="status" name="status" class="form-control">
                                    <option @if(1) selected @endif value="1">@lang('Active')</option>
                                    <option @if(0) selected @endif value="0">@lang('Inactive')</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn--primary">@lang('Submit')</button>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection



@push('script')
<script>
    (function ($) {
            "use strict";

            $('.addCategory').on('click', function() {
                $('#addCityModel').modal('show');
            });

            $('.editModalBtn').on('click', function () {
                var modal = $('#editCategoryModal');
                var data = $(this).data('data');

                modal.find('input[name=id]').val(data.id);
                modal.find('input[name=name]').val(data.name);
                modal.find('select[name=status]').val(data.status);
                modal.modal('show');
            });



        })(jQuery);

</script>
@endpush
