@extends('admin.layouts.app')
@section('panel')


<div class="d-flex flex-wrap justify-content-end mb-3">
    <div class="d-inline">
        <div class="input-group justify-content-end">
            <input type="text" name="search_table" class="form-control bg--white"
                placeholder="@lang('Search Tag')...">
            <button class="btn btn--primary input-group-text"><i class="fa fa-search"></i></button>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-body p-0">
                <div class="table-responsive--sm table-responsive">
                    <table class="table table--light style--two custom-data-table">
                        <thead>
                            <tr>
                                <th>@lang('SL')</th>
                                <th>@lang('Tag')</th>
                                <th>@lang('Time')</th>
                                <th>@lang('Action')</th>
                            </tr>
                        </thead>
                        <tbody class="list">
                            @forelse($tags as $key=>$tag)
                            <tr>
                                <td>{{$key+1}}</td>
                                <td>{{__($tag->name)}}</td>
                                <td>
                                    {{showDateTime($tag->created_at)}}
                                </td>
                                <td>
                                    <button type="button" class="btn btn-sm btn--danger deleteModalBtn"
                                        title="@lang('Delete')" data-id="{{$tag->id}}">
                                        <i class="la la-trash"></i>
                                    </button>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td class="text-muted text-center" colspan="100%">{{__($emptyMessage) }}</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
            @if ($tags->hasPages())
            <div class="card-footer py-4">
                {{ paginateLinks($tags) }}
            </div>
            @endif
        </div>
    </div>
</div>


{{-- delete METHOD MODAL --}}
<div id="deleteModal" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"> @lang('Delete Confirmation!')</h5>
                <button type="button" class="close btn btn--danger" data-bs-dismiss="modal" aria-label="Close">
                    <i class="las la-times"></i>
                </button>
            </div>
            <form action="{{route('admin.tag.delete')}}" class="edit-route" method="get" enctype="multipart/form-data">
                @csrf
                <input type="hidden" name="id">

                <div class="modal-body">
                    <div class="row">
                        <p>@lang('are you sure delete this tag?')</p>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="submit" class="btn btn--primary btn-global">@lang('Delete')</button>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection

@push('script')
<script>
    (function ($) {
            "use strict";

            $('.deleteModalBtn').on('click', function () {
                var modal = $('#deleteModal');
                var id = $(this).data('id');
                modal.find('input[name=id]').val(id);
                modal.modal('show');
            });

        })(jQuery);

</script>
@endpush
