@php
    $languages = App\Models\Language::all();
    $pages = App\Models\Page::where('tempname', $activeTemplate)->get();
@endphp
<!-- ==================== Header End Here ==================== -->
<div class="header" id="header">
    <div class="container">
        <nav class="navbar navbar-expand-lg">
            <a class="navbar-brand logo" href="{{route('home')}}">
                <img src="{{ getImage(getFilePath('logoIcon') . '/logo_white.png', '?' . time()) }}" alt="{{ config('app.name') }}">
            </a>
            <button class="navbar-toggler header-button" type="button" data-bs-toggle="collapse"
                data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false"
                aria-label="Toggle navigation">
                <span id="hiddenNav"><i class="las la-bars"></i></span>
            </button>

            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <ul class="navbar-nav nav-menu mx-auto ps-lg-4 ps-0">

                    {{-- demo homepart --}}
                    <li class="nav-item dropdown">
                        <a class="nav-link" href="javascript:void(0)" role="button" data-bs-toggle="dropdown" aria-expanded="false"> @lang('Home')
                            <span class="nav-item__icon"><i class="las la-angle-down"></i></span></a>
                        <ul class="dropdown-menu">
                            <li class="dropdown-menu__list"><a class="dropdown-item dropdown-menu__link" href="{{ route('home') }}?template=1">@lang('Home One')</a></li>
                            <li class="dropdown-menu__list"><a class="dropdown-item dropdown-menu__link" href="{{ route('home') }}?template=2">@lang('Home Two')</a></li>
                        </ul>
                    </li>
                    {{-- end demo homepart --}}

                    @foreach($pages as $page)
                    {{-- demo homepart (remove if condition) --}}
                    @if($page->slug !== '/')
                        <li class="nav-item">
                            <a href="{{ route('pages', [$page->slug]) }}" class="nav-link {{ Request::url() == url('/') . '/' . $page->slug ? 'active' : '' }}" aria-current="page">{{ __($page->name) }}</a>
                        </li>
                    @endif

                   @endforeach
                </ul>
                <div class="nav-end d-lg-flex d-md-flex d-block align-items-center py-lg-0 py-1">
                    <div class="d-flex mx-2">
                        <div class="icon">
                            <i class="fa-solid fa-globe"></i>
                        </div>
                        <select class="select-dir langSel form--select">
                            @foreach ($languages as $language)
                            <option value="{{ $language->code }}"
                                @if (Session::get('lang') === $language->code) selected @endif>
                                {{ __($language->name) }}
                            </option>
                            @endforeach
                        </select>
                    </div>

                    @auth
                    <a class="btn--base mt-2 mt-lg-0" href="{{route('user.home')}}">@lang('Dashboard')</a>
                    @endif

                    @auth('influencer')
                    <a class="btn--base mt-2 mt-lg-0" href="{{route('influencer.home')}}">@lang('Dashboard')</a>
                    @endauth

                    @if (!(auth()->id() || authInfluencerId()))
                        <a class="btn--base mt-2 mt-lg-0" href="{{route('user.login')}}">@lang('Sign In')</a>
                    @endif

                </div>
            </div>
        </nav>
    </div>
</div>
<!-- ==================== Header End Here ==================== -->
