<div class="row gy-4 justify-content-center">
@forelse ($influencers as $influencer)
<div class="{{ request()->route()->uri != '/' ? 'col-xl-4 col-lg-6 col-12' : 'col-xl-3 col-lg-4 col-md-6 col-12' }}">
    <div class="card">
        <div class="d-flex align-items-center mb-3">
            <div class="profile">
                <img src="{{ getImage(getFilePath('influencerProfile').'/'.@$influencer->image,getFileSize('influencerProfile')) }}" alt="@lang('influencer profile')">
            </div>
            <div>
                <div class="main">
                    <h5>
                        @if (strlen(__(@$influencer->fullname)) >13)
                        {{ substr(__(@$influencer->fullname), 0, 13) . '...' }}
                        @else
                        {{__(@$influencer->fullname) }}
                        @endif
                    </h5>
                    <div class="star">
                        <h5>
                            @php
                            echo showRatings($influencer->rating);
                            @endphp
                            <span>({{ getAmount($influencer->total_review) ?? 0 }})</span>
                        </h5>
                    </div>
                    <p>
                        @if (strlen(__($influencer->profession)) >20)
                        {{ substr(__($influencer->profession), 0, 20) . '...' }}
                        @else
                        {{__($influencer->profession) }}
                        @endif
                        </p>
                </div>
            </div>
        </div>
        <div>
            <a href="{{ route('influencer.profile', [slug($influencer->username), $influencer->id]) }}" class="btn--base btn--sm w-100">@lang('View Profile')</a>
        </div>
    </div>
</div>
@empty
<div class="d-flex justify-content-center align-items-center nodata_img">
    <img src="{{ asset($activeTemplateTrue .'images/nodata.png') }}" alt="image">
</div>
@endforelse
</div>
