<div class="row g-5 justify-content-center">
@forelse ($services as $service)
<div class="{{ request()->route()->uri != '/' ? 'col-xl-4 col-lg-6 col-md-12 col-12' : 'col-xl-3 col-lg-4 col-md-6 col-12' }}">
    <div class="card">
        <div class="thumb">
            <img src="{{getImage(getFilePath('serviceImage').'/'.@$service->image)}}" alt="@lang('image')">
            <div class="tag">
                <h6>{{__(@$service->category->name)}}</h6>
            </div>
        </div>
        <div class="content">
            <a href="{{ route('service.details', [slug($service->title), $service->id]) }}" class="w-100">
                <h5>
                    @if (strlen(__(@$service->title)) > 32)
                    {{ substr(__(@$service->title), 0, 32) . '...' }}
                    @else
                    {{__(@$service->title) }}
                    @endif
                </h5>
                <div class="d-flex justify-content-between align-items-center">
                    <div class="star">
                        <h5>
                            @php
                            echo showRatings(@$service->rating);
                            @endphp
                            <span>({{ $service->total_review ?? 0 }})</span>
                        </h5>
                    </div>
                    <div class="price">
                        <h5>{{ $general->cur_sym }}{{ showAmount($service->price) }}</h5>
                    </div>
                </div>
            </a>
            <div class="profile">
                <a href="{{ route('influencer.profile', [slug($service->influencer->username), $service->influencer->id]) }}" class="d-flex">
                    <img src="{{ getImage(getFilePath('influencerProfile').'/'.@$service->influencer->image,getFileSize('influencerProfile')) }}" alt="@lang('influencer profile')">
                    <p>{{__(@$service->influencer->fullname)}}</p>
                </a>
                <div class="d-flex">
                    <a href="javascript:void(0)" class="addToWishList" data-id="{{ $service->id }}" onclick="addToWishlist(this)">
                        @if (auth()->check() && $service->wishlists->where('user_id', auth()->user()->id)->count() > 0)
                            <i class="fas fa-heart text--base"></i>
                        @else
                            <i class="far fa-heart"></i>
                        @endif
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
@empty
<div class="d-flex justify-content-center align-items-center nodata_img">
    <img src="{{ asset($activeTemplateTrue .'images/nodata.png') }}" alt="image">
</div>
@endforelse
</div>

@push('script')
<script>
   function addToWishlist(element) {

    "use strict"

        var isAddingToWishlist = false;
        var isLoggedIn = {{ Auth::check() ? 'true' : 'false' }};

        if (!isAddingToWishlist && isLoggedIn) {
            isAddingToWishlist = true;
            var propertyId = $(element).data('id');

            $.ajax({
                url: '{{ route('user.wishlist.add') }}',
                type: 'get',
                data: {
                    propertyId: propertyId,
                },
                complete: function() {
                    isAddingToWishlist = false;
                },
                success: function(response) {
                    if (response.hasOwnProperty('message')) {
                        Toast.fire({
                            icon: 'success',
                            title: response.message
                        });
                        var heartIcon = $(element).find('i');
                        heartIcon.removeClass('far fa-heart').addClass('fas fa-heart');
                    } else {
                        Toast.fire({
                            icon: 'warning',
                            title: response.error
                        });
                    }
                },
                error: function(xhr, status, error) {
                    var errorMessage = 'Error occurred while adding the item to the wishlist.';
                    Toast.fire({
                        icon: 'error',
                        title: errorMessage
                    });
                }
            });
        } else {
            var errorMessage = 'Please log in to add items to your wishlist and insure are you client?';
            Toast.fire({
                icon: 'warning',
                title: errorMessage
            });

            isAddingToWishlist = false;
        }
    }
</script>
@endpush

