@extends($activeTemplate.'layouts.influencer.master')
@section('content')
<div class="body-wrapper">
    <div class="table-content">
        <div class="row gy-4">
            <div class="col-lg-12 col-12">
                <div class="custom-card support-card">
                    <div class="support-card-wrapper">
                        <div class="card-header">
                            <div class="card-header-user-area">
                                <img class="avatar" src="{{ getImage(getFilePath('userProfile').'/'.@$user->image,getFileSize('userProfile')) }}"  alt="@lang('user profile')">
                                <div class="card-header-user-content">
                                    <span class="sub-title">{{@$user->fullname}}</span>
                                </div>
                            </div>
                        </div>
                        <div class="support-chat-area">
                            @if($user)
                                @include($activeTemplate.'influencer.conversation.message')
                            @endif
                            @if (!($order->status == 1 || $order->status == 5 || $order->status == 6))
                            <form class="chat-form message-input" id="messageForm" method="post" enctype="multipart/form-data">
                                @csrf
                                <input type="hidden" name="order_id" value="{{$order->id}}">
                                <div class="publisher">
                                    <div class="chatbox-message-part">
                                        <input class="publisher-input" type="text" name="message" id="message" placeholder="@lang('Write your message')....">
                                    </div>
                                    <div class="chatbox-send-part">
                                        <button type="button" class="chat-submit-btn msg-submit-btn"><i class="lab la-telegram-plane"></i></button>
                                    </div>
                                </div>
                            </form>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection


@if (auth()->guard('influencer')->user())
@push('script')
<script src="{{asset($activeTemplateTrue.'js/pusher.min.js')}}"></script>
<script>
(function () {
    "use strict";
    var msgContainer = document.querySelector('.messages');
        msgContainer.scrollTop = msgContainer.scrollHeight;

    $('.msg-submit-btn').on('click', function(e) {
        e.preventDefault();
        
        var message = $("input[name=message]").val();
        var order_id = $("input[name=order_id]").val();
        let message_list_wrapper = $('.messages ul');

        var formData = new FormData();

        formData.append('message', message);
        formData.append('order_id', order_id);

        if (message == '') {
            Toast.fire({
                icon: 'error',
                title: 'Message filed are empty.',
            });
            return;
        }

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        $.ajax({
            type: "post",
            url: "{{ route('influencer.service.order.conversation.store') }}",
            data: formData,
            cache: false,
            contentType: false,
            processData: false,
            success: function(data) {
                if (data.message != null) {
                    message_list_wrapper.append(`
                        <li class="media media-chat media-chat-reverse replies">
                            <img class="avatar" src="${data.senderImag}" alt="user">
                            <div class="media-body">
                                <p>${data.message}</p>
                            </div>
                            <span class="comment-date text--secondary">${data.sendTime}</span>
                        </li>
                    `);
                }

                $('input[name=message]').val('');
                var chatBox = $('.messages')[0];
                chatBox.scrollTop = chatBox.scrollHeight;
            },
            error: function(data, status, error) {
                $('input[name=message]').val('');
                $.each(data.responseJSON.errors, function(key,item) {
                    Toast.fire({
                        icon: 'error',
                        title: item
                    })
                });
            }
        });
    })

    // Pusher Setup and Credential and Sender - Receiver Function Start
    var app_key = @json(gs()->pusher_credential->app_key);
    var app_cluster = @json(gs()->pusher_credential->app_cluster);
    var my_channel = "{{ auth()->guard('influencer')->user()->id }}";

    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    var pusher = new Pusher(

        app_key, {
            cluster: app_cluster
        });

    var channel = pusher.subscribe(my_channel);

    channel.bind('App\\Events\\HiringChat', function(data) {

        let message_list_wrapper = $('.messages ul');
        if (data.receiver == my_channel) {
            if (data.message != null) {
                    message_list_wrapper.append(`
                    <li class="media media-chat sent">
                            <img class="avatar" src="${data.senderImag}" alt="user">
                            <div class="media-body">
                                <p>${data.message}</p>
                            </div>
                            <span class="comment-date text--secondary">${data.sendTime}</span>
                        </li>
                    `);
                }
        }
        var chatBox = $('.messages')[0];
        chatBox.scrollTop = chatBox.scrollHeight;
    });

}) ();
</script>
@endpush
@endif






