@extends($activeTemplate.'layouts.influencer.master')
@section('content')

<div class="body-wrapper">
    <div class="table-content">
        <div class="body-area">
            <form action="{{ route('influencer.service.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="form-body">
                    <div class="row g-3">
                        <div class="col-lg-9">
                            <div class="row gy-3">

                                <div class="col-lg-6 col-12">
                                    <div class="form-group">
                                        <label for="title" class="form--label">@lang('Title') <span class="text-danger">*</span></label>
                                        <input type="text" name="title" class="form--control" id="title" placeholder="@lang('Enter Title')" required>
                                    </div>
                                </div>

                                <div class="col-lg-6 col-12">
                                    <div class="form-group">
                                        <label for="category" class="form--label">@lang('Category') <span class="text-danger">*</span></label>
                                        <select name="category_id" class="form-select form--control select" required>
                                            <option value="" selected="" disabled="">@lang('---select category---')</option>
                                            @foreach ($categories as $category)
                                            <option value="{{$category->id}}">{{__($category->name)}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-lg-6 col-12 ">
                                    <div class="form-group">
                                        <label for="price" class="form--label">@lang('Price') <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <input type="number" step="any" class="form-control form--control" name="price" id="price">
                                            <span class="input-group-text">{{$general->cur_text}}</span>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-6 col-12">
                                    <div class="form-group skill-body">
                                        <label for="tags" class="form--label">@lang('Tags') <span class="text-danger">*</span></label>
                                        <select class="select2-auto-tokenize form-control form--control" multiple="multiple" name="tags[]" required>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-lg-12 col-12">
                                    <div class="form-group">
                                        <label for="key_Points" class="form--label">@lang('Key Points') <span class="text-danger">*</span></label>
                                        <div class="key-point d-flex mb-3 gap-2">
                                            <input type="text" class="form-control form--control" name="key_points[]" required>
                                            <button type="button" class="btn--base btn--sm pointBtn">
                                                <i class="las la-plus"></i></button>
                                        </div>
                                        <div id="more-keyPoint"></div>
                                    </div>
                                </div>

                            </div>
                        </div>

                        <div class="col-lg-3">
                           <div class="row gy-3">
                            <div class="col-lg-12 col-12">
                                <div class="form-group">
                                    <div class="image-upload">
                                        <div class="thumb">
                                            <div class="avatar-preview">
                                                <div class="profilePicPreview"
                                                    style="background-image: url({{getImage(getFilePath('serviceImage'),getFileSize('serviceImage')) }})">
                                                    <button type="button" class="remove-image"><i class="fa fa-times"></i>
                                                    </button>
                                                </div>
                                            </div>
                                            <div class="avatar-edit">
                                                <input type="file" class="profilePicUpload" name="image"
                                                    id="profilePicUpload1" accept=".png, .jpg, .jpeg">
                                                <label for="profilePicUpload1" class="btn btn--base">@lang('Upload')</label>
                                                <small class="mt-2 text-danger">@lang('image size') {{getFileSize('serviceImage')}}@lang('px').</small>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                           </div>
                        </div>

                        <div class="col-lg-12 col-12">
                            <div class="form-group">
                                <label for="description" class="form--label">@lang('Description')</label>
                                <textarea rows="4" class="form-control form--control trumEdit" name="description" id="description" placeholder="@lang('Write here')"></textarea>
                            </div>
                        </div>
                        <div class="col-lg-12 text-end">
                            <button type="submit" class="btn btn--base">@lang('Create')</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection

@push('script')
<script>
     (function($) {
            "use strict";

            $(".select2-auto-tokenize").select2({
                tags: true,
                tokenSeparators: [","],
                dropdownParent: $(".skill-body"),
            });

            $('.pointBtn').on('click', function() {
                var html = `
                <div class="key-point d-flex gap-2 mb-3">
                    <input type="text" class="form-control form--control" name="key_points[]" required>
                    <button class="btn btn--danger remove-button border-0" type="button"><i class="fas fa-times"></i></button>
                </div>`;
                $('#more-keyPoint').append(html);
            });

            $(document).on('click', '.remove-button', function() {
                "use strict"
                $(this).closest('.key-point').remove();
            });

    })(jQuery);
</script>
@endpush
