<!doctype html>
<html lang="{{ config('app.locale') }}" itemscope itemtype="http://schema.org/WebPage">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title> {{ $general->siteName(__($pageTitle)) }}</title>
    @include('includes.seo')
      <!-- all css link -->
    @include($activeTemplate.'components.assetsLink.css')

     @stack('style-lib')
     @stack('style')

</head>
<body class="{{$general->rtl == 1 ? 'rtl':'ltr'}}">
    @include($activeTemplate.'components.loader')
    @yield('content')
    @include($activeTemplate.'components.cookie')

    <!-- all js link -->
    @include($activeTemplate.'components.assetsLink.js')

    @stack('script-lib')
    @stack('script')
    @include('includes.plugins')
    @include('includes.notify')

<script>
    (function ($) {
        "use strict";

        $(".langSel").on("change", function() {
            window.location.href = "{{route('home')}}/change/"+$(this).val() ;
        });

        $('.policy').on('click',function(){
            $.get('{{route('cookie.accept')}}', function(response){
                $('.cookies-card').addClass('d-none');
            });
        });

        setTimeout(function(){
            $('.cookies-card').removeClass('hide')
        },2000);

    })(jQuery);
</script>

</body>
</html>
