@php
    $about = getContent('about.content', true);
    $aboutElement = getContent('about.element', false,3);
@endphp
<!--========================== About Start ==========================-->
<section class="about py-80">
    <div class="shape">
        <img src="{{ asset($activeTemplateTrue . 'images/shape/shape1.png') }}" alt="@lang('shape')">
    </div>
    <div class="container">
        <div class="row gy-4">
            <div class="col-lg-5 col-12">
                <div class="title">
                    <h4>{{__(@$about->data_values->heading)}}</h4>
                    <p>{{__(@$about->data_values->sub_heading)}}</p>
                </div>

                @foreach($aboutElement as $item)
                <div class="details">
                    <div class="d-flex">
                        <div class="icon">
                            @php echo @$item->data_values->icon;@endphp
                        </div>
                        <div class="content">
                            <h5>{{__(@$item->data_values->title)}}</h5>
                            <p>{{__(@$item->data_values->short_description)}}</p>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
            <div class="col-lg-7 col-12 my-auto thumb">
                <img src="{{getImage(getFilePath('about').'/'.@$about->data_values->about_image)}}" alt="@lang('image')">
            </div>
        </div>
    </div>
</section>
<!--========================== About End ==========================-->
