@php
$category = getContent('category.content', true);
$categories = App\Models\Category::with('influencers')->where('status',1)->latest()->inRandomOrder()->limit(8)->get();
@endphp
<!-- ==================== Categories start ==================== -->
<section class="categories py-80">
    <div class="shape">
        <img src="{{ asset($activeTemplateTrue . 'images/shape/shape1.png') }}" alt="@lang('shape')">
    </div>
    <div class="container">
        <div class="title">
            <h4>{{__(@$category->data_values->heading)}}</h4>
            <p>{{__(@$category->data_values->sub_heading)}}</p>
        </div>
        <div class="row gy-5 mt-5 justify-content-center">
            @foreach ($categories as $category)
            <div class="col-xl-3 col-lg-4 col-md-6 col-sm-6 col-12">
                <a href="{{ route('influencer.category', [$category->id, slug($category->name)]) }}" class="card">
                    <div class="thumb">
                        <img src="{{getImage(getFilePath('category').'/'.@$category->image)}}" alt="@lang('image')">
                    </div>
                    <div class="content">
                        <h5>
                            @if(strlen(__($category->name)) >30)
                            {{ substr(__($category->name), 0, 30) . '...' }}
                            @else
                            {{__($category->name) }}
                            @endif
                        </h5>
                        <h6>({{$category->influencers->count()}})</h6>
                    </div>
                </a>
            </div>
            @endforeach
        </div>
    </div>
</section>
<!-- ==================== Categories end ==================== -->
