@php
    $testimonial = getContent('testimonial.content', true);
    $testimonialElement = getContent('testimonial.element', false);
@endphp
<!--========================== Testimonial Start ==========================-->
<section class="testimonial py-80">
    <div class="shape">
        <img src="{{ asset($activeTemplateTrue . 'images/shape/shape6.png') }}" alt="@lang('shape')">
    </div>
    <div class="container">
        <div class="title">
            <h4>{{__(@$testimonial->data_values->heading)}}</h4>
            <p>{{__(@$testimonial->data_values->sub_heading)}}</p>
        </div>
        <div class="testimonial-slider">
            @foreach($testimonialElement as $item)
            <div class="card">
                <div class="profile d-flex">
                    <div>
                        <img src="{{getImage(getFilePath('testimonial').'/'.@$item->data_values->testimonial_image)}}" alt="@lang('image')">
                    </div>
                    <div>
                        <h5>{{__(@$item->data_values->title)}}</h5>
                        <p>{{__(@$item->data_values->designation)}}</p>
                    </div>
                </div>
                <div class="content">
                    <p>
                        @if (strlen(__(@$item->data_values->description)) >100)
                        {{ substr(__(@$item->data_values->description), 0, 100) . '...' }}
                        @else
                        {{__(@$item->data_values->description) }}
                        @endif
                    </p>
                </div>
                <div class="star">
                    @php $starIcons = getStarIcons(@$item->data_values->star_count);@endphp
                    {!! $starIcons !!}
                </div>
                <div class="icon">
                    <i class="fas fa-quote-right"></i>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</section>
<!--========================== Testimonial End ==========================-->
