@extends($activeTemplate . 'layouts.frontend')
@section('content')
<!-- ==================== services-details Start ==================== -->
<section class="services-details py-80">
    <div class="container">
        <div class="row gy-4">
            <div class="col-lg-8 col-12">
                <div class="left-side">
                    <div class="top-thumb">
                        <div class="tag">
                            <h6>{{__(@$service->category->name)}}</h6>
                        </div>
                        <img src="{{getImage(getFilePath('serviceImage').'/'.$service->image)}}" alt="@lang('image')">
                    </div>
                    <div class="content">
                        <div class="top-title">
                            <h4>{{__($service->title)}}</h4>
                            <div class="d-flex">
                                <div class="d-flex align-items-center location">
                                    <i class="las la-stream"></i>
                                    <p>{{__(@$service->category->name)}}</p>
                                </div>
                                <div class="d-flex align-items-center star">
                                    @php
                                    echo showRatings(@$service->rating);
                                    @endphp
                                </div>
                            </div>
                        </div>
                        <div>
                            <h5>@lang('Over View')</h5>
                            <p>
                                @php echo $service->description; @endphp
                            </p>
                        </div>
                        <div class="list">
                            <h5>@lang('Tags')</h5>
                            <div class="row">
                                @if(@$service->tags)
                                @foreach ($service->tags??[] as $tag)
                                <div class="col-lg-3 col-md-4 col-12">
                                    <p><a href="{{ route('service.tag', [@$tag->id, slug(@$tag->name)]) }}">{{__(@$tag->name)}}</a></p>
                                </div>
                                @endforeach
                                @endif
                            </div>
                        </div>

                        <div class="customer-review">
                            <h5>@lang('Customer Review')</h5>
                            @if($service->reviews->count()>0)
                            @forelse (@$service->reviews as $review)
                            <div class="profile">
                                <img src="{{ getImage(getFilePath('influencerProfile').'/'.@$review->user->image,getFileSize('influencerProfile')) }}"  alt="@lang('user profile')">
                                <div>
                                    <div class="d-flex justify-content-between">
                                        <h6>{{@$review->user->username}}</h6>
                                        <div class="d-flex align-items-center star">
                                            @php
                                            echo showRatings(@$review->star);
                                            @endphp
                                        </div>
                                    </div>
                                    <p>{{ $review->created_at->format('d M Y') }}</p>
                                    <p class="mt-2">{{__($review->review)}}</p>
                                </div>
                            </div>
                            @empty
                            <p>{{__($emptyMessage)}}</p>
                            @endforelse
                            @else
                            <p>{{__($emptyMessage)}}</p>
                            @endif
                        </div>
                        <div class="review-box">
                            <form action="{{route('user.review.service.store',$service->id)}}" method="post" class="mt-3">
                                @csrf
                            <input type="hidden" name="star" id="rating" value="0">
                            <h5>@lang('Write a review')</h5>
                            <div class="d-flex align-items-center star rating-wrap rating-stars mb-3">
                                <i class="far fa-star" data-rating="1"></i>
                                <i class="far fa-star" data-rating="2"></i>
                                <i class="far fa-star" data-rating="3"></i>
                                <i class="far fa-star" data-rating="4"></i>
                                <i class="far fa-star" data-rating="5"></i>
                            </div>
                                <textarea class="form--control" name="review" placeholder="@lang('Write Your Review')"></textarea>
                                <button type="submit" class="btn--base mt-2">@lang('Submit') </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-12">
                <div class="right-side">
                    <div class="price">
                        <h4>@lang('Price')</h4>
                        <h4>{{$general->cur_sym}}{{showAmount($service->price)}}</h4>
                    </div>
                    <div class="details">
                        @if(@$service->key_points)
                        @foreach ($service->key_points as $point)
                        <p><i class="far fa-check-circle"></i>{{__($point)}}</p>
                        @endforeach
                        @endif
                    </div>
                    @if(!authInfluencerId())
                    <div>
                        <a href="{{ route('user.order.request.form', $service->id) }}" class="btn--base btn--sm w-100 mt-2">@lang('Order Now')</a>
                    </div>
                    @endif
                </div>
                <div class="influencer">
                    <div class="card">
                        <div class="d-flex align-items-center mb-3">
                            <div class="profile">
                                <img src="{{ getImage(getFilePath('influencerProfile') . '/' . @$service->influencer->image, getFileSize('influencerProfile'), true) }}">
                            </div>
                            <div>
                                <div class="main">
                                    <h5>{{__(@$service->influencer->fullname) }}</h5>
                                    <p>{{__(@$service->influencer->profession) }}</p>
                                </div>
                                <div class="star">
                                    <h5>
                                        @php
                                        echo showRatings(@$service->influencer->rating);
                                        @endphp
                                        <span> ({{ getAmount(@$service->influencer->total_review) ?? 0 }})</span>
                                    </h5>
                                </div>
                            </div>
                        </div>
                        <div>
                            <a href="{{ route('influencer.profile', [slug(@$service->influencer->username), @$service->influencer_id]) }}" class="btn--base btn--sm w-100">@lang('View Profile')</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- ==================== services-details End ==================== -->
@endsection

@push('script')
<script>

        // rating set
        $(document).ready(function() {
            'use strict'

            var initialRating = parseInt($('#rating').val());
                if (initialRating > 0) {
                    updateStars(initialRating);
            }

            $('.rating-stars i').on('click', function() {
                var rating = parseInt($(this).data('rating'));
                $('#rating').val(rating);
                updateStars(rating);
            });

            $('#rating').on('input', function() {
                var rating = $(this).val();
                updateStars(rating);
            });


            function updateStars(rating) {
                var stars = $('.rating-stars i');
                stars.removeClass('fas').addClass('far');
                stars.each(function(index) {
                    if (index < rating) {
                        $(this).removeClass('far').addClass('fas');
                    }
                });
            }

        });
        // end rating set
</script>
@endpush
