@extends($activeTemplate.'layouts.client.master')
@section('content')
<div class="body-wrapper">
    <div class="table-content">

        <div class="row  gy-4 mb-3">
            <div class="col-lg-12">
                @if (auth()->user()->kv == 0)
                <div class="kyc-noty d-flex justify-content-between align-items-center" role="alert">
                    <h4 class="alert-heading">@lang('KYC Verification required')</h4>
                    <hr>
                    <p class="mb-0"><a href="{{ route('user.kyc.form') }}" class="btn--base btn--sm">@lang('Click
                            Here to Verify')</a></p>
                </div>
                @elseif(auth()->user()->kv == 2)
                <div class="kyc-noty kyc-noty-pending d-flex justify-content-between align-items-center" role="alert">
                    <h4 class="alert-heading">@lang('KYC Verification pending')</h4>
                    <hr>
                    <p class="mb-0"> <a href="{{ route('user.kyc.data') }}" class="btn--base btn--sm">@lang('See KYC Data')</a></p>
                </div>
                @endif
            </div>
        </div>

        <div class="row gy-4 mb-4">

            <div class="col-xl-3 col-lg-4 col-md-4 col-12">
                <div class="dash-card">
                    <a href="javascript:void(0)" class="d-flex justify-content-between">
                        <div>
                            <div>
                                <p>@lang('Balance')</p>
                            </div>
                            <div class="content">
                                <span class="text-uppercase">{{$general->cur_sym}}{{showAmount($data['balance'])}}</span>
                            </div>

                        </div>
                        <div class="icon my-auto">
                            <i class="fas fa-money-check-alt"></i>
                        </div>
                    </a>
                </div>
            </div>

            <div class="col-xl-3 col-lg-4 col-md-4 col-12">
                <div class="dash-card">
                    <a href="{{route('user.order.index')}}" class="d-flex justify-content-between">
                        <div>
                            <div>
                                <p>@lang('Total Orders')</p>
                            </div>
                            <div class="content">
                                <span class="text-uppercase">{{$data['total_order']}}</span>
                            </div>

                        </div>
                        <div class="icon my-auto">
                            <i class="fas fa-luggage-cart"></i>
                        </div>
                    </a>
                </div>
            </div>

            <div class="col-xl-3 col-lg-4 col-md-4 col-12">
                <div class="dash-card">
                    <a href="{{route('user.order.completed')}}" class="d-flex justify-content-between">
                        <div>
                            <div>
                                <p>@lang('Completed Orders')</p>
                            </div>
                            <div class="content">
                                <span class="text-uppercase">{{$data['complete_order']}}</span>
                            </div>

                        </div>
                        <div class="icon my-auto">
                            <i class="far fa-list-alt"></i>
                        </div>
                    </a>
                </div>
            </div>

            <div class="col-xl-3 col-lg-4 col-md-4 col-12">
                <div class="dash-card">
                    <a href="{{route('user.hiring.index')}}" class="d-flex justify-content-between">
                        <div>
                            <div>
                                <p>@lang('Total Hired')</p>
                            </div>
                            <div class="content">
                                <span class="text-uppercase">{{$data['total_hired']}}</span>
                            </div>

                        </div>
                        <div class="icon my-auto">
                            <i class="fas fa-list"></i>
                        </div>
                    </a>
                </div>
            </div>

        </div>

        <div class="row mb-4">
            <div class="col-12">
                <div class="chart">
                    <div class="chart-bg">
                        <h4>@lang('Monthly Deposit History')</h4>
                        <div id="account-chart"></div>
                    </div>
                </div>
            </div>
        </div>

        <div class="m-0">
            <div class="list-card">
                <div class="header-title-list">
                    <h4 class="pb-0">@lang('Recent Services Order')</h4>
                </div>
                <div class="row justify-content-center">
                    <div class="col-xl-12">
                        <table class="custom-table">
                            <thead>
                                <tr>
                                    <th>@lang('Order Number')</th>
                                    <th>@lang('Influencer')</th>
                                    <th>@lang('Amount')</th>
                                    <th>@lang('Delivary')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($orders as $order)
                                <tr>
                                    <td data-label="@lang('Order Number')"> {{ $order->order_no }} </td>
                                    <td data-label="@lang('Influencer')">
                                        @if(@$order->influencer)
                                        <a href="{{ route('influencer.profile', [slug(@$order->influencer->username), $order->influencer_id]) }}"
                                            class="text--base">{{@$order->influencer->username}}</a>
                                        @else
                                        @lang('N/A')
                                        @endif
                                    </td>
                                    <td data-label="@lang('Amount')">{{$general->cur_sym}}{{ showAmount($order->amount)}}</td>
                                    <td data-label="@lang('Delivary')">{{ showDateTime($order->delivery_date) }}</td>
                                    <td data-label="@lang('Status')">
                                        @php
                                        echo $order->statusBadge($order->status);
                                        @endphp
                                    </td>
                                    <td data-label="@lang('Action')" class="table-dropdown">

                                        <i class="fas fa-ellipsis-v" data-bs-toggle="dropdown"></i>
                                        <ul class="dropdown-menu">
                                            <li>
                                                <a class="dropdown-item" href="{{ route('user.order.detail',$order->id) }}">@lang('Details')</a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item" href="{{ route('user.order.conversation.view',$order->id) }}">@lang('Message')
                                                </a>
                                            </li>
                                        </ul>

                                    </td>
                                </tr>
                                @empty
                                <td class="text-muted text-center" colspan="100%">{{__($emptyMessage) }}</td>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>
@endsection

@push('script')
<script src="{{asset('assets/admin/js/apexcharts.min.js')}}"></script>
<script>
    (function () {
        "use strict";

        var options = {
            chart: {
                type: 'area',
                stacked: false,
                height: '310px'
            },
            stroke: {
                width: [0, 3],
                curve: 'smooth'
            },
            plotOptions: {
                bar: {
                    columnWidth: '50%'
                }
            },
            colors: ['#00adad', '#67BAA7'],
            series: [{
        name: '@lang("Deposits")',
        type: 'area',
        data: @json($depositsChart['values'])
    }],
    fill: {
        opacity: [0.85, 1],
                },
    labels: @json($depositsChart['labels']),
    markers: {
        size: 0
    },
    xaxis: {
        type: 'text'
    },
    yaxis: {
        min: 0
    },
    tooltip: {
        shared: true,
            intersect: false,
                y: {
            formatter: function (y) {
                if (typeof y !== "undefined") {
                    return "$ " + y.toFixed(0);
                }
                return y;

            }
        }
    },
    legend: {
        labels: {
            useSeriesColors: true
        },
        markers: {
            customHTML: [
                function () {
                    return ''
                },
                function () {
                    return ''
                }
            ]
        }
    }
            }
    var chart = new ApexCharts(
        document.querySelector("#account-chart"),
        options
    );
    chart.render();
        }) ();

</script>
@endpush
