@extends($activeTemplate.'layouts.client.master')
@section('content')

<div class="body-wrapper">
    <div class="table-content">
        <div class="row justify-content-center">
            <div class="col-lg-6">
                <div class="body-area">
                    <h5>@lang('Influencer Information')</h5>

                    <ul class="list-group">
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold">@lang('Name')</span>
                            <span>{{__(@$order->influencer->fullname) }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold">@lang('Email')</span>
                            <span>{{@$order->influencer->email }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold">@lang('Country')</span>
                            <span>{{__(@$order->influencer->address->country) }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold">@lang('Member Since')</span>
                            <span>{{ showDateTime(@$order->influencer->created_at) }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold">@lang('Order Complted')</span>
                            <span>{{@$order->influencer->completed_order}}</span>
                        </li>
                        @if(@$order->influencer)
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold">@lang('Influencer Profile')</span>
                            <span><a href="{{ route('influencer.profile', [slug($order->influencer->username), $order->influencer_id]) }}" class="btn--base btn--sm" target="_blank"><i class="las la-external-link-alt"></i></a></span>
                        </li>
                        @endif
                    </ul>

                    @if ($order->status == 3)
                    <div class="mt-4">
                        <h5>@lang('Take Action')</h5>
                        <div class="d-flex flex-wrap gap-2">
                            <button type="button" class="btn--sm btn--base reportBtn" data-id="{{ $order->id }}">
                                <i class="las la-gavel"></i> @lang('Report to Admin')
                            </button>
                            <button type="button" class="btn btn--sm btn--success btn--base confirmationBtn" data-action="{{ route('user.order.complete.status',$order->id) }}" data-question="@lang('Are you sure to complete this order?')" data-btn_class="btn btn--base btn--md">
                                <i class="las la-check-double"></i> @lang('Complete')
                            </button>
                        </div>
                    </div>
                    @endif

                </div>
            </div>
            <div class="col-lg-6">
                <div class="body-area">
                    <h5>@lang('Order Information')</h5>
                    <ul class="list-group">
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold">@lang('Title')</span>
                            <span>{{ $order->title }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold">@lang('Delivery Date')</span>
                            <span>{{ showDateTime($order->delivery_date) }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold">@lang('Amount')</span>
                            <span>{{ showAmount($order->amount) }} {{ $general->cur_text }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold">@lang('Order No')</span>
                            <span>{{ $order->order_no }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold">@lang('Order Status')</span>
                            <span> @php echo $order->statusBadge($order->status) @endphp </span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold">@lang('Description')</span>
                            <button class="btn--sm btn--base descriptionBtn" data-description="{{ $order->description }}">@lang('View')</button>
                        </li>
                        @if ($order->status == 4)
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold">@lang('Reason of Report')</span>
                            <button class="btn--sm btn--base reasonBtn" data-reason="{{ $order->reason }}">@lang('View')</button>
                        </li>
                        @endif
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

{{-- report moal --}}
<div id="reportModal" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">@lang('Report to Admin')</h5>
                <span type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <i class="las la-times"></i>
                </span>
            </div>
            <form action="" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="form-group report-reason">
                        <label class="form-label">@lang('Reason')</label>
                        <textarea name="reason" class="form-control form--control">{{ old('reason') }}</textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn--dark btn--md" data-bs-dismiss="modal">@lang('No')</button>
                    <button type="submit" class="btn btn--base btn--md">@lang('Yes')</button>
                </div>
            </form>
        </div>
    </div>
</div>

{{-- description modal --}}
<div id="descriptionModal" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"></h5>
                <span type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <i class="las la-times"></i>
                </span>
            </div>
            <div class="modal-body">
                <p class="description"></p>
            </div>
        </div>
    </div>
</div>
<x-confirmation-modal></x-confirmation-modal>

@endsection

@push('script')
    <script>
        (function($) {
            "use strict";

            $('.descriptionBtn').on('click',function () {
                var modal = $("#descriptionModal");
                modal.find('.modal-title').text('Description');
                modal.find('.description').html($(this).data('description'));
                modal.modal('show');
            });

            $('.reasonBtn').on('click',function () {
                var modal = $("#descriptionModal");
                modal.find('.modal-title').text('Reason of Report')
                modal.find('.description').text($(this).data('reason'));
                modal.modal('show');
            });

            $('.reportBtn').on('click', function() {
                var modal = $('#reportModal');
                let id = $(this).data('id');
                modal.find('form').attr('action', `{{ route('user.order.report.status','') }}/${id}`);
                modal.modal('show');
            });

        })(jQuery);
    </script>
@endpush
