@extends($activeTemplate.'layouts.client.master')
@section('content')
<div class="body-wrapper">
    <div class="table-content">
        <div class="body-area">
            <form action="{{route('user.order.payment.method')}}" method="post" enctype="multipart/form-data">
                @csrf
                <input type="hidden" name="influencer_id" value="{{$influencer->id}}">
                <input type="hidden" name="service_id" value="{{$service->id}}">
                <div class="form-body">
                    <div class="row gy-3">
                        <div class="col-lg-4 col-12">
                            <div class="form-group">
                                <label for="title" class="form--label">@lang('Title') <span class="text-danger">*</span></label>
                                <input type="text" name="title" class="form--control" id="title" value="{{ old('title') }}" placeholder="@lang('Enter Title')" required>
                            </div>
                        </div>
                        <div class="col-lg-4 col-12">
                            <div class="form-group">
                                <label for="title" class="form--label">@lang('Delivery Date') <span class="text-danger">*</span></label>
                                <input type="text" class="datepicker-here form-control form--control" data-language='en' data-date-format="yyyy-mm-dd" data-position='bottom left' placeholder="@lang('Select date')" name="delivery_date" autocomplete="off" required>
                            </div>
                        </div>
                        <div class="col-lg-4 col-12">
                            <div class="form-group">
                                <label class="form-label">@lang('Price')<span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <input type="number" step="any" class="form-control form--control" name="price" value="{{ $service->price }}" required readonly>
                                    <span class="input-group-text">{{ $general->cur_text }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-12 col-12">
                            <div class="form-group">
                                <label class="form-label" for="description">@lang('Description')</label>
                                <textarea rows="4" class="form-control form--control nicEdit" name="description" id="description" placeholder="@lang('Description')">{{ old('description') }}</textarea>
                            </div>
                        </div>
                        <div class="col-lg-12 text-end">
                            <button type="submit" class="btn--base">@lang('Request')</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('script')
    <script>
        (function () {
        "use strict";

            $('.datepicker-here').datepicker({
                changeYear: true,
                changeMonth: true,
                minDate: new Date(),
            });
    }) ();
    </script>
@endpush


