<?php


Route::namespace('User\Auth')->name('user.')->group(function () {

    Route::controller('LoginController')->group(function(){
        Route::get('/login', 'showLoginForm')->name('login');
        Route::post('/login', 'login');
        Route::get('logout', 'logout')->name('logout');
    });

    Route::controller('RegisterController')->group(function(){
        Route::get('register', 'showRegistrationForm')->name('register');
        Route::post('register', 'register')->middleware('registration.status');
        Route::post('check-mail', 'checkUser')->name('checkUser');
    });

    Route::controller('ForgotPasswordController')->group(function(){
        Route::get('password/reset', 'showLinkRequestForm')->name('password.request');
        Route::post('password/email', 'sendResetCodeEmail')->name('password.email');
        Route::get('password/code-verify', 'codeVerify')->name('password.code.verify');
        Route::post('password/verify-code', 'verifyCode')->name('password.verify.code');
    });
    Route::controller('ResetPasswordController')->group(function(){
        Route::post('password/reset', 'reset')->name('password.update');
        Route::get('password/reset/{token}', 'showResetForm')->name('password.reset');
    });

    Route::controller('SocialiteController')->prefix('social')->group(function () {
        Route::get('login/{provider}', 'socialLogin')->name('social.login');
        Route::get('login/callback/{provider}', 'callback')->name('social.login.callback');
    });
});

Route::middleware('auth')->name('user.')->group(function () {
    //authorization
    Route::namespace('User')->controller('AuthorizationController')->group(function(){
        Route::get('authorization', 'authorizeForm')->name('authorization');
        Route::get('resend/verify/{type}', 'sendVerifyCode')->name('send.verify.code');
        Route::post('verify/email', 'emailVerification')->name('verify.email');
        Route::post('verify/mobile', 'mobileVerification')->name('verify.mobile');
        Route::post('verify/g2fa', 'g2faVerification')->name('go2fa.verify');
    });

    Route::middleware(['check.status'])->group(function () {

        Route::get('user/data', 'User\UserController@userData')->name('data');
        Route::post('user/data/submit', 'User\UserController@userDataSubmit')->name('data.submit');

        Route::middleware('registration.complete')->namespace('User')->group(function () {

            Route::controller('UserController')->group(function(){
                Route::get('dashboard', 'home')->name('home');

                //2FA
                Route::get('twofactor', 'show2faForm')->name('twofactor');
                Route::post('twofactor/enable', 'create2fa')->name('twofactor.enable');
                Route::post('twofactor/disable', 'disable2fa')->name('twofactor.disable');

                //Report
                Route::any('deposit/history', 'depositHistory')->name('deposit.history');
                Route::get('transactions','transactions')->name('transactions');

                Route::get('attachment-download/{fil_hash}','attachmentDownload')->name('attachment.download');


                 //KYC
                 Route::get('kyc-form','kycForm')->name('kyc.form');
                 Route::get('kyc-data','kycData')->name('kyc.data');
                 Route::post('kyc-submit','kycSubmit')->name('kyc.submit');


                 // add wishlist
                 Route::get('property-wishlist-add','addWishlist')->name('wishlist.add');
                 Route::get('property-wishlist-list','fetchWishlist')->name('wishlist.list');
                 Route::get('property-wishlist-remove','removeWishlist')->name('wishlist.remove');
            });

            //Profile setting
            Route::controller('ProfileController')->group(function(){
                Route::get('profile/setting', 'profile')->name('profile.setting');
                Route::post('profile/setting', 'submitProfile');
                Route::get('change-password', 'changePassword')->name('change.password');
                Route::post('change-password', 'submitPassword');
            });

            // hiring
            Route::controller('HiringController')->prefix('hiring-influencer')->name('hiring.')->group(function () {

                Route::get('/', 'index')->name('index');
                Route::get('/pending', 'pending')->name('pending');
                Route::get('/inprogress', 'inprogress')->name('inprogress');
                Route::get('/job-done', 'jobDone')->name('jobDone');
                Route::get('/completed', 'completed')->name('completed');
                Route::get('/reported', 'reported')->name('reported');
                Route::get('/cancelled', 'cancelled')->name('cancelled');

                Route::middleware('client_kyc')->group(function () {

                    Route::get('detail/{id}', 'detail')->name('detail');
                    Route::post('report/status/{id}', 'reportStatus')->name('report.status');
                    Route::post('complete/status/{id}', 'completeStatus')->name('complete.status');
                    Route::post('report/status/{id}', 'reportStatus')->name('report.status');

                    Route::get('hiring/{name}/{id}', 'hiring')->name('request');
                    Route::get('hiring/payment-method', 'hiringPaymentMethod')->name('payment.method');

                    // chat
                    Route::get('hiring-conversation/{id}', 'conversation')->name('conversation.view');
                    Route::post('hiring/conversation/message/store', 'conversationStore')->name('conversation.store');

                });


            });

            // order
            Route::controller('OrderController')->name('order.')->prefix('order')->group(function () {

                Route::get('/index', 'index')->name('index');
                Route::get('/pending', 'pending')->name('pending');
                Route::get('/inprogress', 'inprogress')->name('inprogress');
                Route::get('/job-done', 'jobDone')->name('jobDone');
                Route::get('/completed', 'completed')->name('completed');
                Route::get('/reported', 'reported')->name('reported');
                Route::get('/cancelled', 'cancelled')->name('cancelled');
                Route::get('/detail/{id}', 'detail')->name('detail');
                Route::post('report/status/{id}', 'reportStatus')->name('report.status');
                Route::post('complete/status/{id}', 'completeStatus')->name('complete.status');

                Route::middleware('client_kyc')->group(function () {

                    Route::get('service/{id}', 'orderRequestForm')->name('request.form');
                    Route::post('payment-method', 'orderServicePaymentMethod')->name('payment.method');

                    Route::get('hiring/conversation/{id}', 'conversation')->name('conversation.view');
                    Route::post('hiring/conversation/message/store', 'conversationStore')->name('conversation.store');
                });

            });

            // review
            Route::controller('ReviewController')->prefix('review')->name('review.')->group(function () {

                Route::middleware('client_kyc')->group(function () {

                    Route::post('service/store/{id}', 'storeServiceReview')->name('service.store');
                    Route::get('influencer/{id}', 'reviewInfluencer')->name('influencer');
                    Route::post('influencer/store', 'storeHiringReview')->name('influencer.store');
                });
            });

        });

        // Payment
        Route::middleware('registration.complete')->controller('Gateway\PaymentController')->group(function(){
            Route::any('/deposit', 'deposit')->name('deposit');
            Route::post('/influencer/hiring-payment', 'influencerHiringPayment')->name('influencer.hiring.payment');
            Route::post('/service/order-payment', 'serviceOrderPayment')->name('service.order.payment');
            Route::post('deposit/insert', 'depositInsert')->name('deposit.insert');
            Route::get('deposit/confirm', 'depositConfirm')->name('deposit.confirm');
            Route::get('deposit/manual', 'manualDepositConfirm')->name('deposit.manual.confirm');
            Route::post('deposit/manual', 'manualDepositUpdate')->name('deposit.manual.update');
        });
    });
});
